unit BrushSelector;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  FastCore, StdCtrls, ExtCtrls, ComCtrls, FastIMG, FastDIB, FastSize, Math, FastFX,
  Utility;

type

  TGradientType = (gtLinear, gtRectangular, gtCircular, gtRadial);

  TBrushSelectorForm = class(TForm)
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    FastIMG2: TFastIMG;
    Label1: TLabel;
    ComboBox1: TComboBox;
    Panel1: TPanel;
    Label3: TLabel;
    TrackBar1: TTrackBar;
    Label4: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    TrackBar3: TTrackBar;
    Label2: TLabel;
    Bevel1: TThemeBevel;
    Button1: TButton;
    Panel2: TPanel;
    ScrollBox1: TScrollBox;
    FastIMG1: TFastIMG;
    Button2: TButton;
    Panel3: TPanel;
    ScrollBox2: TScrollBox;
    FastIMG3: TFastIMG;
    Panel5: TPanel;
    Panel4: TPanel;
    ScrollBox3: TScrollBox;
    FastIMG4: TFastIMG;
    Label11: TLabel;
    ComboBox2: TComboBox;
    Panel6: TPanel;
    FastIMG5: TFastIMG;
    Label12: TLabel;
    TrackBar5: TTrackBar;
    Label13: TLabel;
    Label14: TLabel;
    TrackBar6: TTrackBar;
    Label15: TLabel;
    RadioGroup1: TRadioGroup;
    ComboBox3: TComboBox;
    Label16: TLabel;
    CheckBox1: TCheckBox;
    Label5: TLabel;
    TrackBar2: TTrackBar;
    Label6: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    TrackBar4: TTrackBar;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TrackBar1Enter(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure TrackBar4Change(Sender: TObject);
    procedure TrackBar2Change(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure FastIMG1MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure FastIMG1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FastIMG3Click(Sender: TObject);
    procedure FastIMG3MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure FastIMG4MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure FastIMG4Click(Sender: TObject);
    procedure FastIMG1DblClick(Sender: TObject);
    procedure FastIMG3DblClick(Sender: TObject);
    procedure FastIMG4DblClick(Sender: TObject);
    procedure ComboBox2Change(Sender: TObject);
    procedure TrackBar5Change(Sender: TObject);
    procedure TrackBar5Enter(Sender: TObject);
    procedure RadioGroup1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    SetType: Integer;
    CurPattern: Array of Byte;
    CurPatternWidth, CurPatternHeight, CurType, CurSizeX, CurSizeY, CurDensity, CurRotation, PenWidth, PenHeight: Integer;
    CurGraphic: String;
    NowShowing: Boolean;
    DefBrushes, DefFills, Brushes, BrushPos: TStringlist;
    Img1MouseX, Img2MouseY, Img2MouseX, Img1MouseY, Img1Selected, Img2Selected, Img3Selected, Img3MouseX, Img3MouseY: Integer;
    FillDIB, GradRectDIB: TFastDIB;
    GradRect_Repeats: Integer;
    Cancelled: Boolean;
    Greys: Array[0..511] of Byte;
    Procedure MakePreview;
    Procedure MakeFillList;
    Procedure MakeFillList_2;
    Procedure MakeCategoryDIB(DIB: TFastDIB; Fills: TStringlist; MinSize, MaxSize, Offset: Integer; Caption: String; Positions: TStringlist);
    Function  StringToDIB(Str: String; MinSize, MaxSize: Integer; Selected: Boolean): TFastDIB;
    Procedure MakeGradient(BMP: TFastDIB; GradientType: TGradientType; Angle, Repeats: Integer; UseDither: Boolean);
    Procedure BuildGradRect_DIB(GradType: TGradientType; Repeats: Integer);
    Procedure Dither(Var BMP: TFastDIB; DitherType: Integer);
  end;

var
  BrushSelectorForm: TBrushSelectorForm;

Const

  DefaultBrushes: Array [0..12] of String =
     (#0#0#1,
      #2#2#0#1#0#1#1#1#0#1#0,
      #3#3#0#1#1#0#1#1#1#1#1#1#1#1#0#1#1#0,
      #5#5#0#1#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#1#0,
      #7#7#0#0#1#1#1#1#0#0#0#1#1#1#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#1#1#1#0#0#0#1#1#1#1#0#0,
      #2#2#1#1#1#1#1#1#1#1#1,
      #3#3#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1,
      #5#5#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1,
      #7#7#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1,
      #3#3#0#0#0#1#0#0#1#0#0#1#0#0#1#0#0#0,
      #4#3#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0,
      #3#3#1#0#0#0#0#1#0#0#0#0#1#0#0#0#0#1,
      #4#3#1#1#0#0#0#0#1#1#0#0#0#0#1#1#0#0#0#0#1#1);

  DefaultFills: Array[0..141] of String =
     (#15#15#0,#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1,
      #15#15#1,#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1,
      #15#15#1,#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1,
      #15#15#1,#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1,
      #15#15#1,#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1,
      #15#15#1,#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1,
      #15#15#1,#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1,
      #15#15#1,#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1,
      #15#15#1,#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1,
      #15#15#1,#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1,
      #15#15#1,#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1,
      #15#15#0,#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0,
      #15#15#1,#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1,
      #15#15#0,#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0,
      #15#15#0,#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0,
      #15#15#0,#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1,
      #15#15#0,#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#1#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#1#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0,
      #15#15#1,#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1,
      #15#15#0,#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#0,#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1,
      #15#15#0,#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#1#0#0#1#0#0#0#0#0#1#0#0#0#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#0#0#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#0#0#0#0#1#0#0#1#0#0#1#0#0#0#0#0#0#0#1#0#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#1#0#0#0#0#0#0#0#0#0#1#0#0#1#0#0#0#0#0#1#0#0#0#0#1#0#0#1#0#1#0#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#1#0#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#1#1#1#1#1#1#0#1#1#1#0#1#1#1#1#1#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#0#1#0#1#0#0#0#0#0#1#0#1#0#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#0#1#0#1#1#1#0#1#1#1#0#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#1#1#1#1#1#1#0#1#1#1#0#1#1#1#1#1#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#0#1#1#1#0#1#0#1#0#1#0#0#0#0#0#1#0#1#0#1#0#1,
      #15#15#0,#0#0#1#1#1#1#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#0#0#1#1#1#1#0#0#0#0#0#0#1#1#1#0#0#1#0#0#0#1#0#0#1#0#0#1#0#0#0#1#0#1#0#0#0#1#0#1#1#1#0#0#0#0#0#0#1#0#0#0#1#0#1#0#0#0#1#0#0#0#0#1#1#1#0#1#0#0#0#0#0#1#1#1#1#0#1#0#0#0#1#0#0#0#0#0#1#0#0#0#0#1#0#0#0#0#1#0#0#0#0#1#0#0#0#0#0#1#1#1#1#0#0#1#1#0#1#1#1#0#0#0#1#0#0#0#0#1#1#0#0#1#0#0#0#1#0#1#1#1#1#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#1#0#0#1#1#0#0#0#0#0#1#1#1#0#0#0#0#1#1#0#0#1#0#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#1#0#0#0#0#0#0#1#0#1#1#1#0#0#1#1#0#1#0#0#0#0#0#1#1#0#0#0#1#1#0#0,
      #15#15#0,#0#0#0#0#0#0#0#0#0#1#1#1#1#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0,
      #15#15#1,#0#0#0#1#0#0#0#1#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#0#0#0#1#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#0#0#0#1#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#0#0#1#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#0#0#1#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#0#0#0#1#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#0#0#0#1#0#0#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#0#0#0#1#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1,
      #15#15#1,#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#1#0#1#1#1#1#1#1#1#0#0#0#0#0#0#1#0#1#0#1#1#1#1#1#1#0#0#0#0#0#1#0#1#0#1#0#1#1#1#1#1#0#0#0#0#1#0#1#0#1#0#1#0#1#1#1#1#0#0#0#1#0#1#0#1#0#1#0#1#0#1#1#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0,
      #15#15#0,#1#0#0#0#0#0#1#0#0#0#0#1#0#0#0#0#1#0#0#0#0#0#1#1#0#0#0#1#0#0#0#0#1#0#0#0#0#0#1#0#0#0#0#1#0#0#0#0#1#0#0#1#0#0#1#0#0#0#0#1#0#0#0#0#1#0#0#0#0#0#1#0#0#0#0#1#0#0#0#0#1#0#0#0#0#0#1#0#0#0#0#1#0#0#0#0#1#0#0#0#0#0#1#0#0#0#0#1#0#0#1#0#1#0#0#0#1#0#1#0#0#0#0#1#0#0#0#0#1#0#0#0#0#0#1#0#0#1#0#1#0#0#0#0#0#0#0#0#1#0#1#0#0#0#0#1#0#0#0#0#1#0#0#0#0#0#1#0#0#0#0#1#0#0#0#0#1#0#0#0#0#0#1#0#0#0#0#1#0#0#0#0#1#0#0#0#0#0#1#0#0#0#0#1#0#1#0#0#1#0#0#0#0#0#1#0#0#0#0#1#0#0#0#0#1#0#0#0#0#0#1#0#1#0#0#1#0#0#0#0#1#0#0#0#0#0#1#0#0#0#0#1#0#0#0,
      #15#15#1,#1#0#0#0#1#1#0#1#1#0#0#0#1#1#0#1#0#0#0#0#0#1#1#1#0#0#0#0#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#1#0#0#1#0#1#0#0#1#0#0#1#0#0#0#1#1#1#0#0#1#0#0#1#1#1#0#0#1#0#1#1#0#1#1#0#0#0#1#1#0#1#1#0#0#1#1#0#0#0#1#1#0#1#1#0#0#0#1#1#0#1#0#0#0#0#0#1#1#1#0#0#0#0#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#1#0#0#1#0#1#0#0#1#0#0#1#0#0#0#1#1#1#0#0#1#0#0#1#1#1#0#0#1#0#1#1#0#1#1#0#0#0#1#1#0#1#1#0#0,
      #15#15#1,#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0,
      #15#15#0,#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#1#1#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#0#1#1#1#0#1#0#0#0#1#1#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#1#1#0#1#0#0#0#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#0#0#0#1#0#1#1#1#0#0#0#1#0#1#1#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#1#1#0#0#0#1#0#1#1#1#0#0#0#1#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#0#1#1#1#0#1#0#0#0#1#1#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#1#1#0#1#0#0#0#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#0#0#0#1#0#1#1#1#0#0#0#1#0#1#1#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#1#1#0#0#0#1#0#1#1#1#0#0#0#1,
      #15#15#1,#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0,
      #15#15#1,#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#1#1#0#0#1#0#0#1#1#1#0#0#1#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#1#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#1#1#0#0#0#0#0#1#1#1#0#0#1#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1,
      #15#15#0,#0#0#1#1#1#1#0#0#1#0#0#0#0#1#0#0#1#1#0#0#0#0#1#0#0#1#1#0#1#1#1#1#0#1#0#1#1#0#1#1#1#0#0#1#0#0#0#1#0#0#1#0#0#1#0#0#0#1#0#1#1#1#0#1#0#1#1#1#0#0#0#1#1#0#1#0#0#0#1#0#1#0#0#0#1#0#0#0#0#1#1#1#0#1#0#0#0#0#0#1#1#1#1#0#1#0#0#0#1#0#1#1#1#0#1#0#0#0#0#1#0#1#1#0#1#0#0#0#0#1#0#1#1#1#0#1#1#0#1#0#0#1#1#0#1#1#1#0#0#0#1#0#0#0#0#1#1#0#0#1#0#0#0#1#0#1#1#1#1#0#1#0#1#0#0#0#0#1#1#0#1#0#0#0#0#1#0#0#1#1#0#1#1#0#0#1#1#1#0#1#1#0#1#1#0#0#1#0#0#1#1#0#0#0#1#0#0#0#1#0#1#0#1#1#0#0#0#1#1#0#1#0#1#1#1#0#0#1#1#0#1#0#1#0#0#0#1#1#0#0#0#1#1#0#0,
      #15#15#0,#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#1#1#0#1#0#1#1#0#1#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#1#0#1#1#0#0#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#1#0#1#1#0#1#0#1#1#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#1#1#1#1#1#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#1#1#0#1#0#1#1#0#1#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#1#0#1#1#0#0#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#1#1#0#1#1#0#1#0#1#1#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#1#0#0#1#0#1#0#1#1#0#0#0#1#0#1#1#1#0#0#0#1#0#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#1#0#1#1#1#0#0#0#1#0#1#1#1#0#0#1#0#1#0#1#1#0#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#1#0#1#1#0#0#1#0#1#0#1#1#0#0#0#1#0#1#1#1#0#0#0#1#0#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#1#0#1#1#1#0#0#0#1#0#1#1#1#0#0#1#0#1#0#1#1#0#0#1#0#1#0#1#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1,
      #15#15#0,#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0,
      #15#15#0,#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#0#0#0#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#0#0#0#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0,
      #15#15#1,#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0,
      #15#15#0,#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1,
      #15#15#1,#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#1#0#1#0#0#0#1#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#1#0#1#0#0#0#1#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#1#0#1#0#1#0#0#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#0#0#1#0#1#0#1#0#0#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#1#0#1#0#0#0#1#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#1#0#1#0#0#0#1#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#1#0#1#0#1#0#0#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#0#0#1#0#1#0#1#0#0#0#1,
      #15#15#0,#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#1#1#1#0#0#0#0#1#1#1#1#0#0#0#0,
      #15#15#0,#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#1#1#0#0#1#0#0#0#1#1#0#0#1#0#0#0#0#1#1#1#1#0#0#1#0#1#1#1#1#0#0#1#1#0#0#1#1#1#1#0#1#0#0#1#1#1#1#0#0#0#0#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#1#1#0#0#1#0#0#0#1#1#0#0#1#0#0#0#0#1#1#1#1#0#0#1#0#1#1#1#1#0#0#1#1#0#0#1#1#1#1#0#1#0#0#1#1#1#1#0#0#0#0#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0,
      #15#15#0,#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#0#1#0#0#0#0#1#1#0#1#0#0#0#0#1#1#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#1#0#1#1#0#0#0#0#1#0#1#1#0#0#0#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#0#0#0#1#1#0#1#0#0#0#0#1#1#0#1#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0,
      #15#15#1,#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1,
      #15#15#0,#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0,
      #15#15#1,#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#1#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0,
      #15#15#0,#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#1#0#0#1#0#0#0#0#1#0#0#1#0#0#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#0#1#0#0#0#0#1#0#0#1#0#0#0#0#1#0,
      #15#15#0,#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0,
      #15#15#0,#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0,
      #15#15#0,#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0,
      #15#15#0,#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#0#0#1#1#0#0#1#1#0#0#1#1#0#0#1#1,
      #15#15#1,#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#1#1#0#1#1#1#1#1#1#1#0#1,
      #15#15#0,#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#1#1#0#1#1#1#0#1#1#1#0#1#1#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0,
      #15#15#0,#1#0#1#0#1#0#0#0#1#0#1#0#1#0#0#1#0#0#1#0#0#1#0#1#0#0#1#0#0#1#0#0#0#1#0#1#0#1#0#0#0#1#0#1#0#1#0#0#1#0#0#1#0#0#1#0#1#0#0#1#0#0#1#0#0#1#0#1#0#1#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#1#0#1#0#1#0#0#0#0#1#0#1#0#1#1#0#0#1#0#1#0#1#1#0#1#0#1#0#0#0#0#1#1#0#1#0#0#0#0#1#0#1#0#1#0#1#0#0#0#1#0#1#0#1#0#0#1#0#0#1#0#0#1#0#1#0#0#1#0#0#1#0#0#0#1#0#1#0#1#0#0#0#1#0#1#0#1#0#0#1#0#0#1#0#0#1#0#1#0#0#1#0#0#1#0#0#1#0#1#0#1#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#0#0#1#0#1#0#1#0#0#0#0#1#0#1#0#1#1#0#0#1#0#1#0#1#1#0#1#0#1#0#0#0#0#1#1#0#1#0#0#0#0#1,
      #15#15#0,#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#1#1#1#1#1#0#0#0#1#1#1#1#1#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#1#0#0#0#1#1#1#1#1#0#0#0#1#1#1#1#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#0,
      #15#15#0,#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0#0#0#0#0#1#1#0#0#0#0#0#0#1#1#0#1#1#0#0#0#0#0#0#1#1#0#0#0#0#0,
      #15#15#1,#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1,
      #15#15#1,#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0,
      #15#15#0,#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#1#0#1#0#1#0#1#0#1#0#1#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0,
      #15#15#0,#1#1#0#0#0#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#0#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#0#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#1#1#1#1#0#0#1#1#0#0#0#1#0#0#1#1#0#0#0#1#0,
      #15#15#1,#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1#1#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#1#0#0#0#0#0#1#0#1#0#0#0#0#1#0#0#0#1#0#0#0#1#0#0#0#1#0#0#1#0#0#0#0#0#1#0#1#0#0#0#0#0#1#0#0#0#0#0#0#0#0#1#0#0#0#0#0#0#0#1);

implementation

{$R *.DFM}

Uses Paintbox, ROMUtils, UDGEdit;

procedure TBrushSelectorForm.FormCreate(Sender: TObject);
Var
  Idx: Integer;
  TempStr: String;
begin

  Brushes := TStringlist.Create;
  BrushPos := TStringlist.Create;

  DefBrushes := TStringlist.Create;
  For Idx := 0 To High(DefaultBrushes) Do Begin
     TempStr := DefaultBrushes[Idx][1]+#0+DefaultBrushes[Idx][2]+#0+Copy(DefaultBrushes[Idx], 3, 99999);
     DefBrushes.Add(TempStr);
  End;

  Idx := 0;
  DefFills := TStringlist.Create;
  While Idx < High(DefaultFills) Do Begin
     TempStr := DefaultFills[Idx][1]+#0+DefaultFills[Idx][2]+#0+DefaultFills[Idx][3]+DefaultFills[Idx+1];
     DefFills.Add(TempStr);
     Inc(Idx, 2);
  End;

  NowShowing := True;
  FillDIB := TFastDIB.Create;
  GradRect_Repeats := -1;
  GradRectDIB := TFastDIB.Create;
  ComboBox1.ItemIndex := 0;
  ComboBox2.ItemIndex := 0;
  TrackBar5.Position := 0;
  TrackBar6.Position := 0;
  RadioGroup1.ItemIndex := 0;
  PageControl1.BringToFront;
  ComboBox1Change(nil);
  ComboBox2.ItemIndex := 0;
  ComboBox2Change(nil);
  ComboBox3.ItemIndex := 4;

  For idx := 0 To 255 Do Begin
     Greys[idx] := idx;
     Greys[511 - idx] := idx;
  End;

end;

procedure TBrushSelectorForm.FormDestroy(Sender: TObject);
begin

  Brushes.Free;
  BrushPos.Free;
  DefBrushes.Free;
  DefFills.Free;
  FillDIB.Free;
  GradRectDIB.Free;

end;

procedure TBrushSelectorForm.FormShow(Sender: TObject);
Var
  Idx: Integer;
  TempStr: String;
  TempDIB: TFastDIB;
begin

  Cancelled := True;
  GradRect_Repeats := -1;

  Case SetType of

     0: Begin

           Panel5.Visible := False;
           Panel5.SendToBack;
           PageControl1.Visible := True;

           SetLength(CurPattern, Length(ScrPaintForm.CurrentPattern));
           CopyMemory(@CurPattern[0], @ScrPaintForm.CurrentPattern[0], Length(ScrPaintForm.CurrentPattern));
           CurPatternHeight := ScrPaintForm.CurrentPatternHeight;
           CurPatternWidth := ScrPaintForm.CurrentPatternWidth;

           CheckBox1.Visible := True;
           Img1Selected := 0;
           Img2Selected := 0;
           MakeFillList;

           // Find the current pen fill type and pen graphic if necessary.

           If (ScrPaintForm.CurrentPenType = ptGraphical) or (ComboBox1.ItemIndex = 2) Then Begin

              SetLength(TempStr, Length(ScrPaintForm.CurrentBrush));
              CopyMemory(@TempStr[1], @ScrPaintForm.CurrentBrush[0], Length(TempStr));
              TempStr := Chr((ScrPaintForm.CurrentBrushWidth -1) And 255) + Chr((ScrPaintForm.CurrentBrushWidth -1) Shr 8) +
                         Chr((ScrPaintForm.CurrentBrushHeight -1) And 255) + Chr((ScrPaintForm.CurrentBrushHeight -1) Shr 8) + TempStr;

              For Idx := 0 To BrushPos.Count -1 Do Begin
                 If Copy(BrushPos[Idx], 8, 999999) = TempStr Then Begin
                    TempDIB := StringToDIB(Copy(BrushPos[Img1Selected], 8, 999999), 16, FillDIB.Width, False);
                    TempDIB.Draw(FastIMG1.Bmp.hDc, Ord(BrushPos[Img1Selected][1]), GetWord(@BrushPos[Img1Selected][2]));
                    TempDIB.Free;
                    Img1Selected := Idx;
                    TempDIB := StringToDIB(Copy(BrushPos[Img1Selected], 8, 999999), 16, FillDIB.Width, True);
                    TempDIB.Draw(FastIMG1.Bmp.hDc, Ord(BrushPos[Img1Selected][1]), GetWord(@BrushPos[Img1Selected][2]));
                    TempDIB.Free;
                    FastIMG1.Repaint;
                    ScrollBox1.VertScrollBar.Position := Max(0, GetWord(@BrushPos[Img1Selected][2]) - (ScrollBox1.ClientHeight Div 2));
                    Break;
                 End;
              End;

           End;

           SetLength(TempStr, Length(ScrPaintForm.CurrentPattern));
           CopyMemory(@TempStr[1], @ScrPaintForm.CurrentPattern[0], Length(TempStr));
           TempStr := Chr((ScrPaintForm.CurrentBrushWidth -1) And 255) + Chr((ScrPaintForm.CurrentBrushWidth -1) Shr 8) +
                      Chr((ScrPaintForm.CurrentBrushHeight -1) and 255) + Chr((ScrPaintForm.CurrentBrushHeight -1) Shr 8) + TempStr;

           For Idx := 0 To BrushPos.Count -1 Do Begin
              If Copy(BrushPos[Idx], 8, 999999) = TempStr Then Begin
                 TempDIB := StringToDIB(Copy(BrushPos[Img2Selected], 8, 999999), 16, FillDIB.Width, False);
                 TempDIB.Draw(FastIMG3.Bmp.hDc, Ord(BrushPos[Img2Selected][1]), GetWord(@BrushPos[Img2Selected][2]));
                 TempDIB.Free;
                 Img2Selected := Idx;
                 TempDIB := StringToDIB(Copy(BrushPos[Img2Selected], 8, 999999), 16, FillDIB.Width, True);
                 TempDIB.Draw(FastIMG3.Bmp.hDc, Ord(BrushPos[Img2Selected][1]), GetWord(@BrushPos[Img2Selected][2]));
                 TempDIB.Free;
                 FastIMG3.Repaint;
                 Break;
              End;
           End;

           Caption := 'Set Pen style';
           NowShowing := True;

           CurType := Ord(ScrPaintForm.CurrentPenType);
           CurSizeX := ScrPaintForm.CurrentPenSizeX;
           CurSizeY := ScrPaintForm.CurrentPenSizeY;
           CurRotation := ScrPaintForm.CurrentPenRotation;
           CurDensity := ScrPaintForm.CurrentPenDensity;

           TrackBar1.Position := CurSizeX;
           TrackBar3.Position := CurSizeY;
           TrackBar2.Position := CurRotation;
           TrackBar4.Position := CurDensity;

           Label4.Caption := IntToStr(TrackBar1.Position)+'x'+IntToStr(Trackbar3.Position);
           Label10.Caption := IntToStr(TrackBar4.Position)+'%';
           Label6.Caption := IntToStr(TrackBar2.Position)+'';

           ComboBox1Change(nil);
           MakePreview;

        End;

     1: Begin

           Img3Selected := 0;
           MakeFillList_2;
           CheckBox1.Visible := False;

           SetLength(TempStr, Length(ScrPaintForm.CurrentFill));
           CopyMemory(@TempStr[1], @ScrPaintForm.CurrentFill[0], Length(TempStr));
           TempStr := Chr((ScrPaintForm.CurrentBrushWidth -1) And 255) + Chr((ScrPaintForm.CurrentBrushWidth -1) Shr 8) +
                      Chr((ScrPaintForm.CurrentBrushHeight -1) And 255) + Chr((ScrPaintForm.CurrentBrushHeight -1) Shr 8) + TempStr;

           For Idx := 0 To BrushPos.Count -1 Do Begin
              If Copy(BrushPos[Idx], 8, 999999) = TempStr Then Begin
                 TempDIB := StringToDIB(Copy(BrushPos[Img3Selected], 8, 999999), 16, FillDIB.Width, False);
                 TempDIB.Draw(FastIMG4.Bmp.hDc, Ord(BrushPos[Img3Selected][1]), GetWord(@BrushPos[Img3Selected][2]));
                 TempDIB.Free;
                 Img3Selected := Idx;
                 TempDIB := StringToDIB(Copy(BrushPos[Img3Selected], 8, 999999), 16, FillDIB.Width, True);
                 TempDIB.Draw(FastIMG4.Bmp.hDc, Ord(BrushPos[Img3Selected][1]), GetWord(@BrushPos[Img3Selected][2]));
                 TempDIB.Free;
                 FastIMG4.Repaint;
                 Break;
              End;
           End;

           Caption := 'Set Fill style';
           PageControl1.Visible := False;
           Panel5.Visible := True;
           Panel5.BringToFront;

           FastIMG5.Bmp.SetSize(FastIMG5.Width, FastIMG5.Height, 8);
           MakeGradient(FastIMG5.Bmp, TGradientType(RadioGroup1.ItemIndex), TrackBar5.Position, TrackBar6.Position, True);
           Label13.Caption := IntToStr(TrackBar5.Position) + '';
           Label15.Caption := IntToStr(TrackBar6.Position);
           FastIMG5.Repaint;

        End;

  End;

  NowShowing := False;

end;

procedure TBrushSelectorForm.TrackBar1Enter(Sender: TObject);
begin

  Button1.SetFocus;

end;

procedure TBrushSelectorForm.TrackBar1Change(Sender: TObject);
begin

  Label4.Caption := IntToStr(TrackBar1.Position)+'x'+IntToStr(Trackbar3.Position);
  If Not NowShowing then Begin
     CurSizeX := TrackBar1.Position;
     CurSizeY := TrackBar3.Position;
     MakePreview;
  End;

end;

procedure TBrushSelectorForm.TrackBar4Change(Sender: TObject);
begin

  Label10.Caption := IntToStr(TrackBar4.Position)+'%';
  If Not NowShowing then Begin
     CurDensity := TrackBar4.Position;
     MakePreview;
  End;

end;

procedure TBrushSelectorForm.TrackBar2Change(Sender: TObject);
begin

  Label6.Caption := IntToStr(TrackBar2.Position)+'';
  If Not NowShowing then Begin
     CurRotation := TrackBar2.Position;
     MakePreview;
  End;

end;

Procedure TBrushSelectorForm.MakePreview;
Var
  pWidth, pHeight, X, Y, Cx, Cy, tX, tY: Integer;
  pArray: Array of Byte;
  tDIB, tDIB2: TFastDIB;
Begin

  tX := CurSizeX;
  tY := CurSizeY;
  ScrPaintForm.MakePen(TPenType(CurType), CurSizeX, CurSizeY, CurRotation, @BrushPos[Img1Selected][8]);
  PenWidth := CurSizeX;
  PenHeight := CurSizeY;
  CurSizeX := tX;
  CurSizeY := tY;

  With FastIMG2 Do Begin

     Bmp.SetSize(FastIMG2.Width, FastIMG2.Height, 32);
     Bmp.Clear(FRGBn(DisplayPalette[7]));
     Bmp.Rectangle(0, 0, Bmp.Width, Bmp.Height);

     SetLength(pArray, Length(ScrPaintForm.PenArray));
     CopyMemory(@pArray[0], @ScrPaintForm.PenArray[0], Length(pArray));
     pWidth := PenWidth;
     pHeight := PenHeight;
     For X := 0 To pWidth -1 Do
        For Y := 0 To pHeight -1 Do
           If pArray[X + (Y * pWidth)] = 1 Then
              pArray[X + (Y * pWidth)] := CurPattern[((Y Mod CurPatternHeight) * CurPatternWidth) + (X Mod CurPatternWidth)];

     tDIB := TFastDIB.Create;
     tDIB.SetSize(Max(pWidth, pHeight)+4, Max(pWidth, pHeight)+4, 32);
     tDIB.Clear(FRGBn(DisplayPalette[15]));
     Cx := (tDIB.Width Div 2) - (pWidth Div 2);
     Cy := (tDIB.AbsHeight Div 2) - (pHeight Div 2);

     For X := 0 To pWidth -1 Do
        For Y := 0 To pHeight -1 Do
           If pArray[(Y * pWidth) + X] = 1 Then
              tDIB.Pixels32[(pHeight - 1 - Y) + Cy, X + Cx -1] := DisplayPalette[0];

     If (tDIB.Width > Bmp.Width -10) or (tDIB.Height > Bmp.Height - 10) Then Begin
        tDIB2 := TFastDIB.Create;
        tDIB2.SetSize(Bmp.Width - 3, Bmp.Height - 3, 32);
        Bilinear32(tDIB, tDIB2);
        tDIB2.Draw(Bmp.hDc, (Bmp.Width Div 2) - (tDIB2.Width Div 2), (Bmp.Height Div 2) - (tDIB2.Height Div 2));
        tDIB2.Free;
     End Else
        tDIB.Draw(Bmp.hDc, (Bmp.Width Div 2) - (tDIB.Width Div 2), (Bmp.Height Div 2) - (tDIB.Height Div 2));

     tDIB.Free;

  End;

  FastIMG2.Repaint;

End;


procedure TBrushSelectorForm.ComboBox1Change(Sender: TObject);
begin

  CurType := ComboBox1.ItemIndex;

  Case CurType of
     0, 1:
        Begin
           Panel1.Visible := True;
           Panel2.Visible := False;
        End;
     2: Begin
           Panel1.Visible := False;
           Panel2.Visible := True;
        End;
  End;

  If Not NowShowing then MakePreview;

end;

Procedure TBrushSelectorForm.MakeFillList;
Var
  CategoryDIB, TempDIB: TFastDIB;
  TempList: TStringlist;
  Idx, Idx2, X, Y, ByteCounter, BitCounter, ByteVal: Integer;
  TempStr: String;
Begin

  // Make a graphical list of fills - an image, comprising every fill type available.

  FastIMG1.SetBounds(0, 0, ScrollBox1.ClientWidth -1, ScrollBox1.ClientHeight -1);
  ScrollBox1.ScrollBy(0, -ScrollBox1.VertScrollBar.Position);

  FastIMG3.SetBounds(0, 0, ScrollBox2.ClientWidth -1, ScrollBox2.ClientHeight -1);
  ScrollBox2.ScrollBy(0, -ScrollBox2.VertScrollBar.Position);

  BrushPos.Clear;

  TempList := TStringlist.Create;
  TempDIB := TFastDIB.Create;
  CategoryDIB := TFastDIB.Create;
  FillDIB.SetSize(ScrollBox1.ClientWidth - GetSystemMetrics(SM_CXVSCROLL), 1, 32);

  // Run through each of the default shapes and generate a bitmap from each

  MakeCategoryDIB(CategoryDIB, DefBrushes, 16, FillDIB.Width, FillDIB.Height, 'Default pen shapes', BrushPos);
  FillDIB.SetSize(FillDIB.Width, CategoryDIB.Height, 32);
  CategoryDIB.Draw(FillDIB.hDc, 0, 0);

  // Run through each of the default fill styles and generate a bitmap from each

  MakeCategoryDIB(CategoryDIB, DefFills, 16, FillDIB.Width, FillDIB.Height, 'Default fill styles', BrushPos);
  TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
  FillDIB.Draw(TempDIB.hDc, 0, 0);
  FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
  TempDIB.Draw(FillDIB.hDc, 0, 0);
  CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);

  // Make and add a stringlist of UDGs.

  TempList.Clear;
  Idx := GetWord(@Memory[UDG]);

  TempStr := #7#0#7#0;
  ByteCounter := 0;
  While Idx < 65536 Do Begin

     ByteVal := Memory[Idx];
     BitCounter := 128;
     While BitCounter > 0 Do Begin
        If ByteVal and BitCounter <> 0 Then
           TempStr := TempStr + #1
        Else
           TempStr := TempStr + #0;
        BitCounter := BitCounter Shr 1;
     End;
     Inc(Idx);
     Inc(ByteCounter);
     If ByteCounter = 8 Then Begin
        ByteCounter := 0;
        TempList.Add(TempStr);
        TempStr := #7#0#7#0;
     End;

  End;

  MakeCategoryDIB(CategoryDIB, TempList, 16, FillDIB.Width, FillDIB.Height, 'UDGs', BrushPos);

  If CategoryDIB.Width > 1 Then Begin
     TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
     FillDIB.Draw(TempDIB.hDc, 0, 0);
     FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
     TempDIB.Draw(FillDIB.hDc, 0, 0);
     CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
  End;

  // Make and add a stringlist of the system font.

  TempList.Clear;
  Idx := 15616;

  TempStr := #7#0#7#0;
  ByteCounter := 0;
  While Idx < 16384 Do Begin

     ByteVal := Memory[Idx];
     BitCounter := 128;
     While BitCounter > 0 Do Begin
        If ByteVal and BitCounter <> 0 Then
           TempStr := TempStr + #1
        Else
           TempStr := TempStr + #0;
        BitCounter := BitCounter Shr 1;
     End;
     Inc(Idx);
     Inc(ByteCounter);
     If ByteCounter = 8 Then Begin
        ByteCounter := 0;
        TempList.Add(TempStr);
        TempStr := #7#0#7#0;
     End;

  End;

  MakeCategoryDIB(CategoryDIB, TempList, 16, FillDIB.Width, FillDIB.Height, 'Default font', BrushPos);

  If CategoryDIB.Width > 1 Then Begin
     TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
     FillDIB.Draw(TempDIB.hDc, 0, 0);
     FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
     TempDIB.Draw(FillDIB.hDc, 0, 0);
     CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
  End;

  // Make and add a stringlist of the block characters.

  TempList.Clear;
  Idx := 769;

  TempStr := #7#0#7#0;
  ByteCounter := 0;
  While Idx < 897 Do Begin

     ByteVal := RealChars[Idx];
     BitCounter := 128;
     While BitCounter > 0 Do Begin
        If ByteVal and BitCounter <> 0 Then
           TempStr := TempStr + #1
        Else
           TempStr := TempStr + #0;
        BitCounter := BitCounter Shr 1;
     End;
     Inc(Idx);
     Inc(ByteCounter);
     If ByteCounter = 8 Then Begin
        ByteCounter := 0;
        TempList.Add(TempStr);
        TempStr := #7#0#7#0;
     End;

  End;

  MakeCategoryDIB(CategoryDIB, TempList, 16, FillDIB.Width, FillDIB.Height, 'Block Graphics', BrushPos);

  If CategoryDIB.Width > 1 Then Begin
     TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
     FillDIB.Draw(TempDIB.hDc, 0, 0);
     FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
     TempDIB.Draw(FillDIB.hDc, 0, 0);
     CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
  End;

  // Make a stringlist of CHARS, if it's not 15360.

  Idx := GetWord(@Memory[CHARS]) + 256;
  Idx2 := Idx + 768;
  If Idx <> 15616 Then Begin

     TempList.Clear;
     TempStr := #7#0#7#0;
     ByteCounter := 0;
     While Idx < Idx2 Do Begin

        ByteVal := Memory[Idx];
        BitCounter := 128;
        While BitCounter > 0 Do Begin
           If ByteVal and BitCounter <> 0 Then
              TempStr := TempStr + #1
           Else
              TempStr := TempStr + #0;
           BitCounter := BitCounter Shr 1;
        End;
        Inc(Idx);
        Inc(ByteCounter);
        If ByteCounter = 8 Then Begin
           ByteCounter := 0;
           TempList.Add(TempStr);
           TempStr := #7#0#7#0;
        End;

     End;

     MakeCategoryDIB(CategoryDIB, TempList, 16, FillDIB.Width, FillDIB.Height, 'Custom CHARs', BrushPos);

     If CategoryDIB.Width > 1 Then Begin
        TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
        FillDIB.Draw(TempDIB.hDc, 0, 0);
        FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
        TempDIB.Draw(FillDIB.hDc, 0, 0);
        CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
     End;

  End;

  // Add the graphic editor's graphics

  TempList.Clear;

  For Idx := 0 To UDGWindow.NumChars -1 Do Begin

     TempStr := Chr(((UDGWindow.DataWidth * 8) -1) And 255) + Chr(((UDGWindow.DataWidth * 8) -1) Shr 8) +
                Chr((UDGWindow.DataHeight -1) And 255) + Chr((UDGWindow.DataHeight -1) Shr 8);
     For Idx2 := Idx * UDGWindow.DataWidth * UDGWindow.DataHeight to ((Idx +1) * UDGWindow.DataWidth * UDGWindow.DataHeight) -1 Do Begin
        ByteVal := Ord(UDGWindow.Curchars[Idx2 +1]);
        BitCounter := 128;
        While BitCounter > 0 Do Begin
           If ByteVal and BitCounter <> 0 Then
              TempStr := TempStr + #1
           Else
              TempStr := TempStr + #0;
           BitCounter := BitCounter Shr 1;
        End;
     End;
     TempList.Add(TempStr);

  End;

  MakeCategoryDIB(CategoryDIB, TempList, 16, FillDIB.Width, FillDIB.Height, 'Graphic Editor data', BrushPos);

  If CategoryDIB.Width > 1 Then Begin
     TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
     FillDIB.Draw(TempDIB.hDc, 0, 0);
     FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
     TempDIB.Draw(FillDIB.hDc, 0, 0);
     CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
  End;

  // Add the current selection, if there is one.

  With ScrPaintForm Do Begin

     If CurScreen^.SelActive Then Begin

        TempList.Clear;
        TempStr := Chr((CurScreen^.SelWidth -1) And 255) + Chr((CurScreen^.SelWidth -1) Shr 8) +
                   Chr((CurScreen^.SelHeight -1) And 255) + Chr((CurScreen^.SelHeight -1) Shr 8);

        For Y := 0 To CurScreen^.SelHeight -1 Do
           For X := 0 To CurScreen^.SelWidth -1 Do
              If CurScreen^.SelMask[X + (CurScreen^.SelWidth * Y)] = 1 Then
                 TempStr := TempStr + Chr(CurScreen^.SelDetail[X + (CurScreen^.SelWidth * Y)])
              Else
                 TempStr := TempSTr + #0;

        TempList.Add(TempStr);

        MakeCategoryDIB(CategoryDIB, TempList, 16, FillDIB.Width, FillDIB.Height, 'Current selection', BrushPos);

        If CategoryDIB.Width > 1 Then Begin
           TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
           FillDIB.Draw(TempDIB.hDc, 0, 0);
           FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
           TempDIB.Draw(FillDIB.hDc, 0, 0);
           CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
        End;

     End;

  End;

  // Finally, add the history of pens used so far.

  If ScrPaintForm.PenHistory.Count > 0 Then Begin

     MakeCategoryDIB(CategoryDIB, ScrPaintForm.PenHistory, 16, FillDIB.Width, FillDIB.Height, 'Pen shape history', BrushPos);

     If CategoryDIB.Width > 1 Then Begin
        TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
        FillDIB.Draw(TempDIB.hDc, 0, 0);
        FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
        TempDIB.Draw(FillDIB.hDc, 0, 0);
        CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
     End;

  End;

  FastIMG1.Bmp.SetSize(FillDIB.Width, FillDIB.Height, 32);
  FillDIB.Draw(FastIMG1.Bmp.hDc, 0, 0);
  FastIMG1.SetBounds(0, 0, FastIMG1.Bmp.Width, FastIMG1.Bmp.Height);

  FastIMG3.Bmp.SetSize(FillDIB.Width, FillDIB.Height, 32);
  FillDIB.Draw(FastIMG3.Bmp.hDc, 0, 0);
  FastIMG3.SetBounds(0, 0, FastIMG3.Bmp.Width, FastIMG3.Bmp.Height);

  // Draw the currently selected graphic

  TempDIB := StringToDIB(Copy(BrushPos[Img1Selected], 8, 999999), 16, FillDIB.Width, True);
  TempDIB.Draw(FastIMG1.Bmp.hDc, Ord(BrushPos[Img1Selected][1]), GetWord(@BrushPos[Img1Selected][2]));
  TempDIB.Free;

  TempDIB := StringToDIB(Copy(BrushPos[Img2Selected], 8, 999999), 16, FillDIB.Width, True);
  TempDIB.Draw(FastIMG3.Bmp.hDc, Ord(BrushPos[Img2Selected][1]), GetWord(@BrushPos[Img2Selected][2]));
  TempDIB.Free;

  CategoryDIB.Free;
  TempList.Free;

  FastIMG1.Repaint;

End;

Procedure TBrushSelectorForm.MakeCategoryDIB(DIB: TFastDIB; Fills: TStringlist; MinSize, MaxSize, Offset: Integer; Caption: String; Positions: TStringlist);
Var
  DIBWidth, DIBHeight, LargestHeight, X, Y, Idx, ImgW, ImgH: Integer;
  Delta: Extended;
  ImgDIB: TFastDIB;
Begin

  DIB.SetSize(1, 1, 32);

  Idx := 0;
  While Idx < Fills.Count Do Begin

     If Pos(#1, Copy(Fills[Idx], 3, 999999)) = 0 Then
        Fills.Delete(Idx)
     Else
        Inc(Idx);

  End;

  If Fills.Count = 0 Then Exit;

  // Determine the maximum height of the DIB - saves having to resize and redraw the DIB later on.

  DIBWidth := 8;
  DIBHeight := 16;
  Idx := 0;
  LargestHeight := 1;

  While Idx < Fills.Count Do Begin

     ImgW := Max(GetWord(@Fills[Idx][1]), MinSize) + 5;
     ImgH := Max(GetWord(@Fills[Idx][3]), MinSize) + 5;

     If ImgW > MaxSize - 8 Then Begin

        Delta := (MaxSize - 8) / ImgW;
        ImgW := MaxSize - 8;
        ImgH := Max(Round(ImgH * Delta), MinSize) + 5;

     End;

     If LargestHeight < ImgH Then
        LargestHeight := ImgH;

     If DIBWidth + ImgW < (MaxSize - 8) Then Begin
        Inc(DIBWidth, ImgW);
     End Else Begin
        DIBWidth := 8;
        Inc(DIBHeight, LargestHeight);
        LargestHeight := 1;
     End;

     Inc(Idx);

  End;

  DIB.SetSize(MaxSize, DIBHeight + LargestHeight, 32);
  DIB.Clear(TfWindow);

  // Render the caption for this lot.

  SpecTextToDIB(DIB, 4, 4, Caption, 1, -1, 0, True, False);

  // Output the graphics - each one is generated as a DIB and then pasted in.

  X := 4; Y := 16;

  Idx := 0;
  LargestHeight := 1;

  While Idx < Fills.Count Do Begin

     ImgDIB := StringToDIB(Fills[Idx], MinSize, MaxSize -8, False);

     If ImgDIB.Width + 8 + X > MaxSize Then Begin

        X := 4;
        Inc(Y, LargestHeight +4);
        LargestHeight := 1;

     End;

     ImgDIB.Draw(DIB.hDc, X, Y);
     Positions.Add(Chr(X)+
                   Chr((Y + Offset) and 255)+Chr(((Y + Offset) Shr 8) And 255)+
                   Chr(ImgDIB.Width And 255)+Chr(ImgDIB.Width Shr 8)+
                   Chr(ImgDIB.Height and 255)+Chr((ImgDIB.Height Shr 8) And 255)+
                   Fills[Idx]);

     Inc(X, ImgDIB.Width + 4);
     If LargestHeight < ImgDIB.Height Then
        LargestHeight := ImgDIB.Height;

     ImgDIB.Free;
     Inc(Idx);

  End;

End;

Function TBrushSelectorForm.StringToDIB(Str: String; MinSize, MaxSize: Integer; Selected: Boolean): TFastDIB;
Var
  Y, X, Xc, Yc: Integer;
  Delta: Extended;
  TempDIB: TFastDIB;
  Tfc, Tfp: TFColor;
Begin

  If Selected Then Begin

     Tfc.r := TfHighlight.r;
     Tfc.g := TfHighlight.g;
     Tfc.b := TfHighlight.b;

     Tfp.r := TfHighlightText.r;
     Tfp.g := TfHighlightText.g;
     Tfp.b := TfHighlightText.b;

  End Else Begin

     Tfc.r := Round(((TFWindow.r / 4) * 3) + (TFShadow.r / 4));
     Tfc.g := Round(((TFWindow.g / 4) * 3) + (TFShadow.g / 4));
     Tfc.b := Round(((TFWindow.b / 4) * 3) + (TFShadow.b / 4));

     Tfp.r := TfText.r;
     Tfp.g := TfText.g;
     Tfp.b := TfText.b;

  End;

  Result := TFastDIB.Create;
  Result.SetSize(Max(GetWord(@Str[1]) +1, MinSize), Max(GetWord(@Str[3]) +1, MinSize), 32);

  Xc := (Result.Width - (GetWord(@Str[1]) +1)) Div 2;
  Yc := (Result.Height - (GetWord(@Str[3]) +1)) Div 2;

  Result.Clear(TFc);

  For Y := 0 To GetWord(@Str[3]) Do
     For X := 0 To GetWord(@Str[1]) Do
        If Str[5 + X + (Y * (GetWord(@Str[1]) +1))] = #1 Then Begin
           Result.Pixels32[Y+Yc, X+Xc].b := Tfp.b;
           Result.Pixels32[Y+Yc, X+Xc].g := Tfp.g;
           Result.Pixels32[Y+Yc, X+Xc].r := Tfp.r;
        End;

  Flop(Result);

  If Result.Width > MaxSize Then Begin

     Delta := MaxSize / Result.Width;
     TempDIB := TFastDIB.Create;
     TempDIB.SetSize(MaxSize, Max(1, Round(Result.Height * Delta)), 32);
     Bilinear32(Result, TempDIB);
     Result.SetSize(MaxSize, Max(MinSize, TempDIB.Height), 32);
     Result.Clear(TFc);
     TempDIB.Draw(Result.hDc, 0, (Result.Height - TempDIB.Height) Div 2);

  End;


End;

procedure TBrushSelectorForm.FastIMG1MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin

  Img1MouseX := X;
  Img1MouseY := Y;

end;

procedure TBrushSelectorForm.FastIMG1Click(Sender: TObject);
Var
  Idx, Bx, By, X, Y, Bw, Bh, Selected: Integer;
  TempDIB: TFastDIB;
begin

  // Get new selection

  X := Img1MouseX;
  Y := Img1MouseY;
  Selected := -1;
  For Idx := 0 To BrushPos.Count -1 Do Begin

     Bx := Ord(BrushPos[Idx][1]);
     By := GetWord(@BrushPos[Idx][2]);
     Bw := Bx + GetWord(@BrushPos[Idx][4]);
     Bh := By + GetWord(@BrushPos[Idx][6]);

     If (X >= Bx) and (Y >= By) and (X < Bw) and (Y < Bh) Then Begin
        Selected := Idx;
        Break;
     End;

  End;

  If Selected > -1 Then Begin

     // Clear current selection

     TempDIB := StringToDIB(Copy(BrushPos[Img1Selected], 8, 999999), 16, FillDIB.Width, False);
     TempDIB.Draw(FastIMG1.Bmp.hDc, Ord(BrushPos[Img1Selected][1]), GetWord(@BrushPos[Img1Selected][2]));
     TempDIB.Free;

     // Set new selection

     Img1Selected := Selected;
     TempDIB := StringToDIB(Copy(BrushPos[Img1Selected], 8, 999999), 16, FillDIB.Width, True);
     TempDIB.Draw(FastIMG1.Bmp.hDc, Ord(BrushPos[Img1Selected][1]), GetWord(@BrushPos[Img1Selected][2]));
     TempDIB.Free;

     FastIMG1.Repaint;
     MakePreview;

  End;

end;

procedure TBrushSelectorForm.Button1Click(Sender: TObject);
begin

  Cancelled := True;
  Close;

end;

procedure TBrushSelectorForm.Button2Click(Sender: TObject);
begin

  Cancelled := False;
  If SetType = 0 Then Begin
     ScrPaintForm.CurrentPenType := TPenType(CurType);
     ScrPaintForm.CurrentPenSizeX := CurSizeX;
     ScrPaintForm.CurrentPenSizeY := CurSizeY;
     ScrPaintForm.CurrentPenRotation := CurRotation;
     ScrPaintForm.CurrentPenDensity := CurDensity;
  End;
  Close;

end;

procedure TBrushSelectorForm.FastIMG3MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin

  Img2MouseX := X;
  Img2MouseY := Y;

end;

procedure TBrushSelectorForm.FastIMG3Click(Sender: TObject);
Var
  Idx, Bx, By, X, Y, Bw, Bh, Selected: Integer;
  TempDIB: TFastDIB;
begin

  // Get new selection

  X := Img2MouseX;
  Y := Img2MouseY;
  Selected := -1;
  For Idx := 0 To BrushPos.Count -1 Do Begin

     Bx := Ord(BrushPos[Idx][1]);
     By := GetWord(@BrushPos[Idx][2]);
     Bw := Bx + GetWord(@BrushPos[Idx][4]);
     Bh := By + GetWord(@BrushPos[Idx][6]);

     If (X >= Bx) and (Y >= By) and (X < Bw) and (Y < Bh) Then Begin
        Selected := Idx;
        Break;
     End;

  End;

  If Selected > -1 Then Begin

     // Clear current selection

     TempDIB := StringToDIB(Copy(BrushPos[Img2Selected], 8, 999999), 16, FillDIB.Width, False);
     TempDIB.Draw(FastIMG3.Bmp.hDc, Ord(BrushPos[Img2Selected][1]), GetWord(@BrushPos[Img2Selected][2]));
     TempDIB.Free;

     // Set new selection

     Img2Selected := Selected;
     TempDIB := StringToDIB(Copy(BrushPos[Img2Selected], 8, 999999), 16, FillDIB.Width, True);
     TempDIB.Draw(FastIMG3.Bmp.hDc, Ord(BrushPos[Img2Selected][1]), GetWord(@BrushPos[Img2Selected][2]));
     TempDIB.Free;

     FastIMG3.Repaint;
     MakePreview;

  End;

end;

Procedure TBrushSelectorForm.MakeFillList_2;
Var
  CategoryDIB, TempDIB: TFastDIB;
  TempList: TStringlist;
  Idx, Idx2, X, Y, ByteCounter, BitCounter, ByteVal: Integer;
  TempStr: String;
Begin

  // Pretty much a carbon copy of the above, but for the fill style. This is a wider DIB, so needs its own proc.
  // Am I not the laziest person *ever*?

  FastIMG4.SetBounds(0, 0, ScrollBox3.ClientWidth -1, ScrollBox3.ClientHeight -1);
  ScrollBox3.ScrollBy(0, -ScrollBox3.VertScrollBar.Position);

  BrushPos.Clear;

  TempList := TStringlist.Create;
  TempDIB := TFastDIB.Create;
  CategoryDIB := TFastDIB.Create;
  FillDIB.SetSize(ScrollBox3.ClientWidth - GetSystemMetrics(SM_CXVSCROLL), 1, 32);

  MakeCategoryDIB(CategoryDIB, DefBrushes, 16, FillDIB.Width, FillDIB.Height, 'Default pen shapes', BrushPos);
  FillDIB.SetSize(FillDIB.Width, CategoryDIB.Height, 32);
  CategoryDIB.Draw(FillDIB.hDc, 0, 0);

  MakeCategoryDIB(CategoryDIB, DefFills, 16, FillDIB.Width, FillDIB.Height, 'Default fill styles', BrushPos);
  TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
  FillDIB.Draw(TempDIB.hDc, 0, 0);
  FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
  TempDIB.Draw(FillDIB.hDc, 0, 0);
  CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);

  TempList.Clear;
  Idx := GetWord(@Memory[UDG]);

  TempStr := #7#0#7#0;
  ByteCounter := 0;
  While Idx < 65536 Do Begin

     ByteVal := Memory[Idx];
     BitCounter := 128;
     While BitCounter > 0 Do Begin
        If ByteVal and BitCounter <> 0 Then
           TempStr := TempStr + #1
        Else
           TempStr := TempStr + #0;
        BitCounter := BitCounter Shr 1;
     End;
     Inc(Idx);
     Inc(ByteCounter);
     If ByteCounter = 8 Then Begin
        ByteCounter := 0;
        TempList.Add(TempStr);
        TempStr := #7#0#7#0;
     End;

  End;

  MakeCategoryDIB(CategoryDIB, TempList, 16, FillDIB.Width, FillDIB.Height, 'UDGs', BrushPos);

  If CategoryDIB.Width > 1 Then Begin
     TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
     FillDIB.Draw(TempDIB.hDc, 0, 0);
     FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
     TempDIB.Draw(FillDIB.hDc, 0, 0);
     CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
  End;

  TempList.Clear;
  Idx := 15616;

  TempStr := #7#0#7#0;
  ByteCounter := 0;
  While Idx < 16384 Do Begin

     ByteVal := Memory[Idx];
     BitCounter := 128;
     While BitCounter > 0 Do Begin
        If ByteVal and BitCounter <> 0 Then
           TempStr := TempStr + #1
        Else
           TempStr := TempStr + #0;
        BitCounter := BitCounter Shr 1;
     End;
     Inc(Idx);
     Inc(ByteCounter);
     If ByteCounter = 8 Then Begin
        ByteCounter := 0;
        TempList.Add(TempStr);
        TempStr := #7#0#7#0;
     End;

  End;

  MakeCategoryDIB(CategoryDIB, TempList, 16, FillDIB.Width, FillDIB.Height, 'Default font', BrushPos);

  If CategoryDIB.Width > 1 Then Begin
     TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
     FillDIB.Draw(TempDIB.hDc, 0, 0);
     FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
     TempDIB.Draw(FillDIB.hDc, 0, 0);
     CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
  End;

  TempList.Clear;
  Idx := 769;

  TempStr := #7#0#7#0;
  ByteCounter := 0;
  While Idx < 897 Do Begin

     ByteVal := RealChars[Idx];
     BitCounter := 128;
     While BitCounter > 0 Do Begin
        If ByteVal and BitCounter <> 0 Then
           TempStr := TempStr + #1
        Else
           TempStr := TempStr + #0;
        BitCounter := BitCounter Shr 1;
     End;
     Inc(Idx);
     Inc(ByteCounter);
     If ByteCounter = 8 Then Begin
        ByteCounter := 0;
        TempList.Add(TempStr);
        TempStr := #7#0#7#0;
     End;

  End;

  MakeCategoryDIB(CategoryDIB, TempList, 16, FillDIB.Width, FillDIB.Height, 'Block Graphics', BrushPos);

  If CategoryDIB.Width > 1 Then Begin
     TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
     FillDIB.Draw(TempDIB.hDc, 0, 0);
     FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
     TempDIB.Draw(FillDIB.hDc, 0, 0);
     CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
  End;

  Idx := GetWord(@Memory[CHARS]) + 256;
  Idx2 := Idx + 768;
  If Idx <> 15616 Then Begin

     TempList.Clear;
     TempStr := #7#0#7#0;
     ByteCounter := 0;
     While Idx < Idx2 Do Begin

        ByteVal := Memory[Idx];
        BitCounter := 128;
        While BitCounter > 0 Do Begin
           If ByteVal and BitCounter <> 0 Then
              TempStr := TempStr + #1
           Else
              TempStr := TempStr + #0;
           BitCounter := BitCounter Shr 1;
        End;
        Inc(Idx);
        Inc(ByteCounter);
        If ByteCounter = 8 Then Begin
           ByteCounter := 0;
           TempList.Add(TempStr);
           TempStr := #7#0#7#0;
        End;

     End;

     MakeCategoryDIB(CategoryDIB, TempList, 16, FillDIB.Width, FillDIB.Height, 'Custom CHARs', BrushPos);

     If CategoryDIB.Width > 1 Then Begin
        TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
        FillDIB.Draw(TempDIB.hDc, 0, 0);
        FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
        TempDIB.Draw(FillDIB.hDc, 0, 0);
        CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
     End;

  End;

  TempList.Clear;

  For Idx := 0 To UDGWindow.NumChars -1 Do Begin

     TempStr := Chr(((UDGWindow.DataWidth * 8) -1) And 255) + Chr(((UDGWindow.DataWidth * 8) -1) Shr 8) +
                Chr((UDGWindow.DataHeight -1) And 255) + Chr((UDGWindow.DataHeight -1) Shr 8);
     For Idx2 := Idx * UDGWindow.DataWidth * UDGWindow.DataHeight to ((Idx +1) * UDGWindow.DataWidth * UDGWindow.DataHeight) -1 Do Begin
        ByteVal := Ord(UDGWindow.Curchars[Idx2 +1]);
        BitCounter := 128;
        While BitCounter > 0 Do Begin
           If ByteVal and BitCounter <> 0 Then
              TempStr := TempStr + #1
           Else
              TempStr := TempStr + #0;
           BitCounter := BitCounter Shr 1;
        End;
     End;
     TempList.Add(TempStr);

  End;

  MakeCategoryDIB(CategoryDIB, TempList, 16, FillDIB.Width, FillDIB.Height, 'Graphic Editor data', BrushPos);

  If CategoryDIB.Width > 1 Then Begin
     TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
     FillDIB.Draw(TempDIB.hDc, 0, 0);
     FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
     TempDIB.Draw(FillDIB.hDc, 0, 0);
     CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
  End;

  With ScrPaintForm Do Begin

     If CurScreen^.SelActive Then Begin

        TempList.Clear;
        TempStr := Chr((CurScreen^.SelWidth -1) And 255) + Chr((CurScreen^.SelWidth -1) Shr 8) +
                   Chr((CurScreen^.SelHeight -1) And 255) + Chr((CurScreen^.SelHeight -1) Shr 8);

        For Y := 0 To CurScreen^.SelHeight -1 Do
           For X := 0 To CurScreen^.SelWidth -1 Do
              If CurScreen^.SelMask[X + (CurScreen^.SelWidth * Y)] = 1 Then
                 TempStr := TempStr + Chr(CurScreen^.SelDetail[X + (CurScreen^.SelWidth * Y)])
              Else
                 TempStr := TempSTr + #0;

        TempList.Add(TempStr);

        MakeCategoryDIB(CategoryDIB, TempList, 16, FillDIB.Width, FillDIB.Height, 'Current selection', BrushPos);

        If CategoryDIB.Width > 1 Then Begin
           TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
           FillDIB.Draw(TempDIB.hDc, 0, 0);
           FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
           TempDIB.Draw(FillDIB.hDc, 0, 0);
           CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
        End;

     End;

  End;

  If ScrPaintForm.PenHistory.Count > 0 Then Begin

     MakeCategoryDIB(CategoryDIB, ScrPaintForm.PenHistory, 16, FillDIB.Width, FillDIB.Height, 'Pen shape history', BrushPos);

     If CategoryDIB.Width > 1 Then Begin
        TempDIB.SetSize(FillDIB.Width, FillDIB.Height, 32);
        FillDIB.Draw(TempDIB.hDc, 0, 0);
        FillDIB.SetSize(FillDIB.Width, FillDIB.Height + CategoryDIB.Height, 32);
        TempDIB.Draw(FillDIB.hDc, 0, 0);
        CategoryDIB.Draw(FillDIB.hDc, 0, TempDIB.Height);
     End;

  End;

  FastIMG4.Bmp.SetSize(FillDIB.Width, FillDIB.Height, 32);
  FillDIB.Draw(FastIMG4.Bmp.hDc, 0, 0);
  FastIMG4.SetBounds(0, 0, FastIMG4.Bmp.Width, FastIMG4.Bmp.Height);

  // Draw the currently selected graphic

  TempDIB := StringToDIB(Copy(BrushPos[Img3Selected], 8, 999999), 16, FillDIB.Width, True);
  TempDIB.Draw(FastIMG4.Bmp.hDc, Ord(BrushPos[Img3Selected][1]), GetWord(@BrushPos[Img3Selected][2]));
  TempDIB.Free;

  CategoryDIB.Free;
  TempList.Free;

  FastIMG4.Repaint;

End;

procedure TBrushSelectorForm.FastIMG4MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin

  Img3MouseX := X;
  Img3MouseY := Y;

end;

procedure TBrushSelectorForm.FastIMG4Click(Sender: TObject);
Var
  Idx, Bx, By, X, Y, Bw, Bh, Selected: Integer;
  TempDIB: TFastDIB;
begin

  // Get new selection

  X := Img3MouseX;
  Y := Img3MouseY;
  Selected := -1;
  For Idx := 0 To BrushPos.Count -1 Do Begin

     Bx := Ord(BrushPos[Idx][1]);
     By := GetWord(@BrushPos[Idx][2]);
     Bw := Bx + GetWord(@BrushPos[Idx][4]);
     Bh := By + GetWord(@BrushPos[Idx][6]);

     If (X >= Bx) and (Y >= By) and (X < Bw) and (Y < Bh) Then Begin
        Selected := Idx;
        Break;
     End;

  End;

  If Selected > -1 Then Begin

     // Clear current selection

     TempDIB := StringToDIB(Copy(BrushPos[Img3Selected], 8, 999999), 16, FillDIB.Width, False);
     TempDIB.Draw(FastIMG4.Bmp.hDc, Ord(BrushPos[Img3Selected][1]), GetWord(@BrushPos[Img3Selected][2]));
     TempDIB.Free;

     // Set new selection

     Img3Selected := Selected;
     TempDIB := StringToDIB(Copy(BrushPos[Img3Selected], 8, 999999), 16, FillDIB.Width, True);
     TempDIB.Draw(FastIMG4.Bmp.hDc, Ord(BrushPos[Img3Selected][1]), GetWord(@BrushPos[Img3Selected][2]));
     TempDIB.Free;

     FastIMG4.Repaint;

  End;

end;

procedure TBrushSelectorForm.FastIMG1DblClick(Sender: TObject);
Var
  X, Y, Bx, By, Bw, Bh, Idx, Selected: Integer;
begin

  X := Img1MouseX;
  Y := Img1MouseY;
  Selected := -1;
  For Idx := 0 To BrushPos.Count -1 Do Begin

     Bx := Ord(BrushPos[Idx][1]);
     By := GetWord(@BrushPos[Idx][2]);
     Bw := Bx + GetWord(@BrushPos[Idx][4]);
     Bh := By + GetWord(@BrushPos[Idx][6]);

     If (X >= Bx) and (Y >= By) and (X < Bw) and (Y < Bh) Then Begin
        Selected := Idx;
        Break;
     End;

  End;

  If Selected > -1 Then Begin

     Cancelled := False;
     Close;

  End;

end;

procedure TBrushSelectorForm.FastIMG3DblClick(Sender: TObject);
Var
  X, Y, Bx, By, Bw, Bh, Idx, Selected: Integer;
begin

  X := Img2MouseX;
  Y := Img2MouseY;
  Selected := -1;
  For Idx := 0 To BrushPos.Count -1 Do Begin

     Bx := Ord(BrushPos[Idx][1]);
     By := GetWord(@BrushPos[Idx][2]);
     Bw := Bx + GetWord(@BrushPos[Idx][4]);
     Bh := By + GetWord(@BrushPos[Idx][6]);

     If (X >= Bx) and (Y >= By) and (X < Bw) and (Y < Bh) Then Begin
        Selected := Idx;
        Break;
     End;

  End;

  If Selected > -1 Then Begin

     Cancelled := False;
     Close;

  End;

end;

procedure TBrushSelectorForm.FastIMG4DblClick(Sender: TObject);
Var
  X, Y, Bx, By, Bw, Bh, Idx, Selected: Integer;
begin

  X := Img3MouseX;
  Y := Img3MouseY;
  Selected := -1;
  For Idx := 0 To BrushPos.Count -1 Do Begin

     Bx := Ord(BrushPos[Idx][1]);
     By := GetWord(@BrushPos[Idx][2]);
     Bw := Bx + GetWord(@BrushPos[Idx][4]);
     Bh := By + GetWord(@BrushPos[Idx][6]);

     If (X >= Bx) and (Y >= By) and (X < Bw) and (Y < Bh) Then Begin
        Selected := Idx;
        Break;
     End;

  End;

  If Selected > -1 Then Begin

     Cancelled := False;
     Close;

  End;

end;

procedure TBrushSelectorForm.ComboBox2Change(Sender: TObject);
begin

  Case ComboBox2.ItemIndex of

     0: Begin
           Panel4.Visible := True;
           Panel6.Visible := False;
        End;

     1: Begin
           Panel4.Visible := False;
           Panel6.Visible := True;
        End;

  End;

end;

Procedure TBrushSelectorForm.MakeGradient(BMP: TFastDIB; GradientType: TGradientType; Angle, Repeats: Integer; UseDither: Boolean);
Var
  lQuad, MinGrad, MaxGrad, g, r, i, j, iIn, iEnd, jIn, jEnd,
  luSin, luCos, Offset, Scan, RLen: Integer;
  AngleDiag, AngleComp, AngleRad: Extended;
  GradArray, Image: Array of Byte;
  TempDIB: TFastDIB;
Begin

  If (BMP.Width > 0) And (BMP.AbsHeight > 0) Then Begin

     BMP.SetSize(BMP.Width, BMP.AbsHeight, 8);
     For i := 0 to 255 Do Begin
        BMP.Colors[i].r := i;
        BMP.Colors[i].g := i;
        BMP.Colors[i].b := i;
     End;
     BMP.UpdateColors;

     If Repeats > 0 Then
        RLen := 512
     Else
        RLen := 256;

     Case GradientType of

        gtLinear:
           Begin

              Angle := (-Angle + 90) Mod 360;
              While Angle < 0 Do Inc(Angle, 360);

              lQuad := Angle Div 90;
              Angle := Angle Mod 90;

              If lQuad Mod 2 = 0 Then
                 AngleDiag := ArcTan(BMP.Width / BMP.AbsHeight) * (180 / PI)
              Else
                 AngleDiag := ArcTan(BMP.AbsHeight / BMP.Width) * (180 / PI);

              AngleComp := (90 - Abs(Angle - AngleDiag)) * (PI / 180);
              AngleRad := Angle * (PI / 180);
              g := Round(Sqrt(BMP.Width * BMP.Width + BMP.AbsHeight * BMP.AbsHeight) * Sin(AngleComp));

              If lQuad > 1 Then Begin
                 If Repeats = 0 Then Begin
                    MinGrad := 255;
                    MaxGrad := 0;
                 End Else Begin
                    MinGrad := 0;
                    MaxGrad := 255;
                 End;
              End Else Begin
                 MinGrad := 0;
                 MaxGrad := 255;
              End;

              SetLength(GradArray, g);

              iEnd := g - 1;
              If (iEnd = 0) Then
                 GradArray[0] := Round(MinGrad / 2 + MaxGrad / 2)
              Else
                 For i := 0 To iEnd Do
                    GradArray[i] := Greys[Abs(Round(MinGrad + ((MaxGrad - MinGrad) * (i * (Repeats +1))) / iEnd)) Mod RLen];

              iEnd := BMP.Width - 1;
              jEnd := BMP.AbsHeight - 1;

              Case lQuad of

                 0, 2:
                    Begin
                       luSin := Round(Sin(AngleRad) * 1000);
                       luCos := Round(Cos(AngleRad) * 1000);
                       Offset := 0;
                       Scan := BMP.Width;
                    End;

                 1, 3:
                    Begin
                       luSin := Round(Sin(90 * PI/180 - AngleRad) * 1000);
                       luCos := Round(Cos(90 * PI/180 - AngleRad) * 1000);
                       Offset := jEnd * BMP.Width;
                       Scan := -BMP.Width;
                    End;

              End;

              jIn := 0;
              For j := 0 To jEnd Do Begin
                 iIn := jIn;
                 For i := 0 To iEnd Do Begin
                    BMP.Pixels8[OffSet Div BMP.Width, i] := GradArray[Round(iIn / 1000)];
                    iIn := iIn + luSin;
                 End;
                 jIn := jIn + luCos;
                 Offset := Offset + Scan;
              End;

           End;

        gtRectangular:
           Begin

              If Repeats <> GradRect_Repeats Then BuildGradRect_DIB(GradientType, Repeats);

              TempDIB := TFastDIB.Create;

              lQuad := Angle Mod 90;
              If lQuad > 45 Then lQuad := 90 - lQuad;
              TempDIB.SetSize(Round((256/cos(DegToRad(lQuad)))*2), Round((256/cos(DegToRad(lQuad)))*2), 8);
              FastFX.Rotate(GradRectDIB, TempDIB, Angle, True);
              Bilinear8(TempDIB, BMP);

              TempDIB.Free;

           End;

        gtCircular:
           Begin

              If Repeats <> GradRect_Repeats Then BuildGradRect_DIB(GradientType, Repeats);
              Bilinear8(GradRectDIB, BMP);

           End;

        gtRadial:
           Begin

              For i := 0 To BMP.Width -1 Do
                 For j := 0 To BMP.AbsHeight -1 Do Begin

                    r := Round(360 - ((Arctan2(i - (BMP.Width Div 2), j - (BMP.AbsHeight Div 2)))* 180/PI) + Angle) Mod 360;
                    r := Round((r/360) * RLen);
                    r := Greys[(r * (Repeats + 1)) Mod RLen];

                    BMP.Pixels8[j, i] := r;

                 End;

           End;

     End;

     If UseDither Then Begin

        TempDIB := TFastDIB.Create;
        TempDIB.SetSize(BMP.Width * 2, BMP.AbsHeight * 2, 8);
        TempDIB.Colors := BMP.Colors;
        TempDIB.UpdateColors;

        BMP.Draw(TempDIB.hDc, 0, BMP.AbsHeight);
        BMP.Draw(TempDIB.hDc, BMP.Width, 0);
        BMP.Draw(TempDIB.hDc, 0, 0);
        BMP.Draw(TempDIB.hDc, BMP.Width, BMP.AbsHeight);
        Dither(TempDIB, ComboBox3.ItemIndex);
        TempDIB.Draw(BMP.hDc, -BMP.Width, 0);
        TempDIB.Free;

     End;

  End;

End;

Procedure TBrushSelectorForm.BuildGradRect_DIB(GradType: TGradientType; Repeats: Integer);
Var
  i, j, r, jIn, RLen: Integer;
Begin

  If Repeats > 0 Then
     RLen := 512
  Else
     RLen := 256;

  GradRectDIB.SetSize(512, 512, 8);

  Case GradType of

     gtRectangular:
        Begin

           For i := 0 To 255 Do
              For j := i To 255 Do Begin
                 jIn := Greys[((511 - Round(511 * (511 - i)/511)) * (Repeats +1)) Mod RLen];
                 GradRectDIB.Pixels8[i, j] := jIn;
                 GradRectDIB.Pixels8[j, i] := jIn;
                 GradRectDIB.Pixels8[i, 511 - j] := jIn;
                 GradRectDIB.Pixels8[j, 511 - i] := jIn;
                 GradRectDIB.Pixels8[511 - i, j] := jIn;
                 GradRectDIB.Pixels8[511 - j, i] := jIn;
                 GradRectDIB.Pixels8[511 - i, 511 - j] := jIn;
                 GradRectDIB.Pixels8[511 - j, 511 - i] := jIn;
              End;

        End;

     gtCircular:

        Begin

           For i := 0 To 255 Do
              For j := 0 To 255 Do Begin

                 r := 255 - Round(Sqrt(((255 - i) * (255 - i)) + ((255 - j) * (255 - j))));
                 If r < 0 Then r := 0;
                 r:= Greys[(r * (Repeats + 1)) Mod RLen];

                 GradRectDIB.Pixels8[j, i] := r;
                 GradRectDIB.Pixels8[j, 511 - i] := r;
                 GradRectDIB.Pixels8[511 - j, i] := r;
                 GradRectDIB.Pixels8[511 - j, 511 - i] := r;

              End;

        End;

  End;

  GradRect_Repeats := Repeats;

End;

procedure TBrushSelectorForm.TrackBar5Change(Sender: TObject);
begin

  MakeGradient(FastIMG5.Bmp, TGradientType(RadioGroup1.ItemIndex), TrackBar5.Position, TrackBar6.Position, True);
  Label13.Caption := IntToStr(TrackBar5.Position) + '';
  Label15.Caption := IntToStr(TrackBar6.Position);
  FastIMG5.Repaint;

end;

procedure TBrushSelectorForm.TrackBar5Enter(Sender: TObject);
begin

  Button2.SetFocus;

end;

procedure TBrushSelectorForm.RadioGroup1Click(Sender: TObject);
begin

  If TGradientType(RadioGroup1.ItemIndex) = gtCircular Then Begin
     TrackBar5.Enabled := False;
     Label12.Enabled := False;
     Label13.Enabled:= False;
  End Else Begin
     TrackBar5.Enabled := True;
     Label12.Enabled := True;
     Label13.Enabled:= True;
  End;

  GradRect_Repeats := -1;
  MakeGradient(FastIMG5.Bmp, TGradientType(RadioGroup1.ItemIndex), TrackBar5.Position, TrackBar6.Position, True);
  Label13.Caption := IntToStr(TrackBar5.Position) + '';
  Label15.Caption := IntToStr(TrackBar6.Position);
  FastIMG5.Repaint;

end;

Procedure TBrushSelectorForm.Dither(var BMP: TFastDIB; DitherType: Integer);
Var
  Y, X, Clr, Offset, Err: Integer;
  DitherArray: Array of Integer;
Const
  DitherArray16: Array[0..3, 0..3] of Byte =
     ((00, 08, 02, 10),
      (12, 04, 14, 06),
      (03, 11, 01, 09),
      (15, 07, 13, 05));
  DitherArray64: Array[0..7,0..7] of Byte =
    ((0, 32, 8, 40, 2, 34, 10, 42),
     (16, 48, 24, 58, 18, 50, 26, 58),
     (4, 36, 12, 44,  6, 38, 14, 46),
     (20, 52, 28, 60, 22, 54, 30, 62),
     (1, 33,  9, 41,  3, 35, 11, 43),
     (17, 49, 25, 57, 19, 51, 27, 59),
     (5, 37, 13, 45,  7, 39, 15, 47),
     (21, 53, 29, 61, 23, 55, 31, 63));
  DiagonalArray: Array[0..8, 0..8] of Byte =
    ((8, 6, 4, 2, 1, 3, 5, 7, 9),
     (6, 4, 2, 1, 3, 5, 7, 9, 8),
     (4, 2, 1, 3, 5, 7, 9, 8, 6),
     (2, 1, 3, 5, 7, 9, 8, 6, 4),
     (1, 3, 5, 7, 9, 8, 6, 4, 2),
     (3, 5, 7, 9, 8, 6, 4, 2, 1),
     (5, 7, 9, 8, 6, 4, 2, 1, 3),
     (7, 9, 8, 6, 4, 2, 1, 3, 5),
     (9, 8, 6, 4, 2, 1, 3, 5, 7));
  ClusterArray: Array [0..9] of String =
     ('000000000',
      '000010000',
      '000011000',
      '010011000',
      '011011000',
      '011011010',
      '011111010',
      '011111110',
      '111111110',
      '111111111');
  DispersedArray: Array [0..9] of String =
     ('000000000',
      '100000000',
      '100000010',
      '100001010',
      '101001010',
      '101101010',
      '101101110',
      '111101110',
      '111111110',
      '111111111');
Begin

  Case DitherType of

     0: // Random dot
        Begin
           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin
                 Clr := BMP.Pixels8[Y, X];
                 If Random(255) > Clr Then
                    BMP.Pixels8[Y, X] := 0
                 Else
                    BMP.Pixels8[Y, X] := 255;
              End;
           End;
        End;

     1: // 9-Level Diagonal Dither
        Begin

           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin
                 Clr := BMP.Pixels8[Y, X];
                 If Clr Div 26 >= DiagonalArray[X Mod 9, Y Mod 9] Then
                    BMP.Pixels8[Y, X] := 255
                 Else
                    BMP.Pixels8[Y, X] := 0;
              End;
           End;
        End;

     2: // Clustered Dot Dither
        Begin

           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin
                 Clr := BMP.Pixels8[Y, X];
                 If ClusterArray[Clr Div 26][(((Y Mod 3) * 3) + X Mod 3) +1] = '1' Then
                    BMP.Pixels8[Y, X] := 255
                 Else
                    BMP.Pixels8[Y, X] := 0;
              End;
           End;
        End;

     3: // Dispersed Dot Dither
        Begin

           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin
                 Clr := BMP.Pixels8[Y, X];
                 If DispersedArray[Clr Div 26][(((Y Mod 3) * 3) + X Mod 3) +1] = '1' Then
                    BMP.Pixels8[Y, X] := 255
                 Else
                    BMP.Pixels8[Y, X] := 0;
              End;
           End;
        End;

     4: // 16-Level Ordered Dither
        Begin

           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin
                 Clr := BMP.Pixels8[Y, X];
                 If Clr Div 15 > DitherArray16[X Mod 4, Y Mod 4] Then
                    BMP.Pixels8[Y, X] := 255
                 Else
                    BMP.Pixels8[Y, X] := 0;
              End;
           End;
        End;

     5: // 64-Level Ordered Dither
        Begin

           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin
                 Clr := BMP.Pixels8[Y, X];
                 If Clr Div 4 > DitherArray64[X Mod 8, Y Mod 8] Then
                    BMP.Pixels8[Y, X] := 255
                 Else
                    BMP.Pixels8[Y, X] := 0;
              End;
           End;
        End;

     6: // Floyd-Steinberg
        Begin

           If Length(DitherArray) <> BMP.Width * BMP.AbsHeight Then
              SetLength(DitherArray, BMP.Width * BMP.AbsHeight);

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do
              For X := 0 To BMP.Width -1 Do Begin
                 DitherArray[Offset] := BMP.Pixels8[Y, X];
                 Inc(Offset);
              End;

           For Y := 0 To BMP.AbsHeight -1 Do Begin
              Offset := Y * BMP.Width;
              For X := 0 To BMP.Width -1 Do Begin

                 If DitherArray[Offset] < 0 Then DitherArray[Offset] := 0;
                 If DitherArray[Offset] > 255 Then DitherArray[Offset] := 255;

                 Clr := (DitherArray[Offset] Div 128) * 255;
                 Err := DitherArray[Offset] - Clr;
                 BMP.Pixels8[Y, X] := Clr;

                 If X < BMP.Width -1 Then Inc(DitherArray[Offset +1], Round((Err/16) * 7));
                 If (X > 0) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + BMP.Width -1], Round((Err/16) * 3));
                 If Y < BMP.AbsHeight -1 Then Inc(DitherArray[Offset + BMP.Width], Round((Err/16) * 5));
                 If (X < BMP.Width -1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 1 + BMP.Width], Round((Err/16) * 1));
                 Inc(Offset);

              End;
           End;
        End;

     7: // Jarvis Error Diffusion
        Begin

           If Length(DitherArray) <> BMP.Width * BMP.AbsHeight Then
              SetLength(DitherArray, BMP.Width * BMP.AbsHeight);

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do
              For X := 0 To BMP.Width -1 Do Begin
                 DitherArray[Offset] := BMP.Pixels8[Y, X];
                 Inc(Offset);
              End;

           Offset := 0;

           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin

                 If DitherArray[Offset] < 0 Then DitherArray[Offset] := 0;
                 If DitherArray[Offset] > 255 Then DitherArray[Offset] := 255;

                 Clr := (DitherArray[Offset] Div 128) * 255;
                 Err := DitherArray[Offset] - Clr;
                 BMP.Pixels8[Y, X] := Clr;

                 If X < BMP.Width -1 Then Inc(DitherArray[Offset +1], Round((Err/48) * 7));
                 If X < BMP.Width -2 Then Inc(DitherArray[Offset +2], Round((Err/48) * 5));
                 If (X > 1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 2 + BMP.Width], Round((Err/48) * 3));
                 If (X > 0) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 1 + BMP.Width], Round((Err/48) * 5));
                 If Y < BMP.AbsHeight -1 Then Inc(DitherArray[Offset + BMP.Width], Round((Err/48) * 7));
                 If (X < BMP.Width -1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 1 + BMP.Width], Round((Err/48) * 5));
                 If (X < BMP.Width -2) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 2 + BMP.Width], Round((Err/48) * 3));
                 If (X > 1) And (Y < BMP.AbsHeight -2) Then Inc(DitherArray[Offset - 2 + (BMP.Width * 2)], Round((Err/48) * 1));
                 If (X > 0) And (Y < BMP.AbsHeight -2) Then Inc(DitherArray[Offset - 1 + (BMP.Width * 2)], Round((Err/48) * 3));
                 If Y < BMP.AbsHeight -2 Then Inc(DitherArray[Offset + (BMP.Width * 2)], Round((Err/48) * 5));
                 If (X < BMP.Width -1) And (Y < BMP.AbsHeight -2) Then Inc(DitherArray[Offset + 1 + (BMP.Width * 2)], Round((Err/48) * 3));
                 If (X < BMP.Width -2) And (Y < BMP.AbsHeight -2) Then Inc(DitherArray[Offset + 2 + (BMP.Width * 2)], Round((Err/48) * 1));

                 Inc(Offset);

              End;
           End;

        End;

     8: // Stucki Error Diffusion
        Begin

           If Length(DitherArray) <> BMP.Width * BMP.AbsHeight Then
              SetLength(DitherArray, BMP.Width * BMP.AbsHeight);

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do
              For X := 0 To BMP.Width -1 Do Begin
                 DitherArray[Offset] := BMP.Pixels8[Y, X];
                 Inc(Offset);
              End;

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin

                 If DitherArray[Offset] < 0 Then DitherArray[Offset] := 0;
                 If DitherArray[Offset] > 255 Then DitherArray[Offset] := 255;

                 Clr := (DitherArray[Offset] Div 128) * 255;
                 Err := DitherArray[Offset] - Clr;
                 BMP.Pixels8[Y, X] := Clr;

                 If X < BMP.Width -1 Then Inc(DitherArray[Offset +1], Round((Err/42) * 8));
                 If X < BMP.Width -2 Then Inc(DitherArray[Offset +2], Round((Err/42) * 4));
                 If (X > 1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 2 + BMP.Width], Round((Err/42) * 2));
                 If (X > 0) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 1 + BMP.Width], Round((Err/42) * 4));
                 If Y < BMP.AbsHeight -1 Then Inc(DitherArray[Offset + BMP.Width], Round((Err/42) * 8));
                 If (X < BMP.Width -1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 1 + BMP.Width], Round((Err/42) * 4));
                 If (X < BMP.Width -2) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 2 + BMP.Width], Round((Err/42) * 2));
                 If (X > 1) And (Y < BMP.AbsHeight -2) Then Inc(DitherArray[Offset - 2 + (BMP.Width * 2)], Round((Err/42) * 1));
                 If (X > 0) And (Y < BMP.AbsHeight -2) Then Inc(DitherArray[Offset - 1 + (BMP.Width * 2)], Round((Err/42) * 2));
                 If Y < BMP.AbsHeight -2 Then Inc(DitherArray[Offset + (BMP.Width * 2)], Round((Err/42) * 4));
                 If (X < BMP.Width -1) And (Y < BMP.AbsHeight -2) Then Inc(DitherArray[Offset + 1 + (BMP.Width * 2)], Round((Err/42) * 2));
                 If (X < BMP.Width -2) And (Y < BMP.AbsHeight -2) Then Inc(DitherArray[Offset + 2 + (BMP.Width * 2)], Round((Err/42) * 1));

                 Inc(Offset);

              End;
           End;

        End;

     9: // Burkes Error Diffusion
        Begin

           If Length(DitherArray) <> BMP.Width * BMP.AbsHeight Then
              SetLength(DitherArray, BMP.Width * BMP.AbsHeight);

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do
              For X := 0 To BMP.Width -1 Do Begin
                 DitherArray[Offset] := BMP.Pixels8[Y, X];
                 Inc(Offset);
              End;

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin

                 If DitherArray[Offset] < 0 Then DitherArray[Offset] := 0;
                 If DitherArray[Offset] > 255 Then DitherArray[Offset] := 255;

                 Clr := (DitherArray[Offset] Div 128) * 255;
                 Err := DitherArray[Offset] - Clr;
                 BMP.Pixels8[Y, X] := Clr;

                 If X < BMP.Width -1 Then Inc(DitherArray[Offset +1], Round((Err/32) * 8));
                 If X < BMP.Width -2 Then Inc(DitherArray[Offset +2], Round((Err/32) * 4));
                 If (X > 1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 2 + BMP.Width], Round((Err/32) * 2));
                 If (X > 0) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 1 + BMP.Width], Round((Err/32) * 4));
                 If Y < BMP.AbsHeight -1 Then Inc(DitherArray[Offset + BMP.Width], Round((Err/32) * 8));
                 If (X < BMP.Width -1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 1 + BMP.Width], Round((Err/32) * 4));
                 If (X < BMP.Width -2) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 2 + BMP.Width], Round((Err/32) * 2));

                 Inc(Offset);

              End;
           End;
        End;

    10: // Sierra-3 Error Diffusion
        Begin

           If Length(DitherArray) <> BMP.Width * BMP.AbsHeight Then
              SetLength(DitherArray, BMP.Width * BMP.AbsHeight);

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do
              For X := 0 To BMP.Width -1 Do Begin
                 DitherArray[Offset] := BMP.Pixels8[Y, X];
                 Inc(Offset);
              End;

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin

                 If DitherArray[Offset] < 0 Then DitherArray[Offset] := 0;
                 If DitherArray[Offset] > 255 Then DitherArray[Offset] := 255;

                 Clr := (DitherArray[Offset] Div 128) * 255;
                 Err := DitherArray[Offset] - Clr;
                 BMP.Pixels8[Y, X] := Clr;

                 If X < BMP.Width -1 Then Inc(DitherArray[Offset +1], Round((Err/32) * 5));
                 If X < BMP.Width -2 Then Inc(DitherArray[Offset +2], Round((Err/32) * 3));
                 If (X > 1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 2 + BMP.Width], Round((Err/32) * 2));
                 If (X > 0) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 1 + BMP.Width], Round((Err/32) * 4));
                 If Y < BMP.AbsHeight -1 Then Inc(DitherArray[Offset + BMP.Width], Round((Err/32) * 5));
                 If (X < BMP.Width -1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 1 + BMP.Width], Round((Err/32) * 4));
                 If (X < BMP.Width -2) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 2 + BMP.Width], Round((Err/32) * 2));
                 If (X > 0) And (Y < BMP.AbsHeight -2) Then Inc(DitherArray[Offset - 1 + (BMP.Width * 2)], Round((Err/32) * 2));
                 If Y < BMP.AbsHeight -2 Then Inc(DitherArray[Offset + (BMP.Width * 2)], Round((Err/32) * 3));
                 If (X < BMP.Width -1) And (Y < BMP.AbsHeight -2) Then Inc(DitherArray[Offset + 1 + (BMP.Width * 2)], Round((Err/32) * 2));

                 Inc(Offset);

              End;
           End;

        End;

    11: // Sierra-2 Error Diffusion
        Begin

           If Length(DitherArray) <> BMP.Width * BMP.AbsHeight Then
              SetLength(DitherArray, BMP.Width * BMP.AbsHeight);

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do
              For X := 0 To BMP.Width -1 Do Begin
                 DitherArray[Offset] := BMP.Pixels8[Y, X];
                 Inc(Offset);
              End;

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin

                 If DitherArray[Offset] < 0 Then DitherArray[Offset] := 0;
                 If DitherArray[Offset] > 255 Then DitherArray[Offset] := 255;

                 Clr := (DitherArray[Offset] Div 128) * 255;
                 Err := DitherArray[Offset] - Clr;
                 BMP.Pixels8[Y, X] := Clr;

                 If X < BMP.Width -1 Then Inc(DitherArray[Offset +1], Round((Err/16) * 4));
                 If X < BMP.Width -2 Then Inc(DitherArray[Offset +2], Round((Err/16) * 3));
                 If (X > 1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 2 + BMP.Width], Round((Err/16) * 1));
                 If (X > 0) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 1 + BMP.Width], Round((Err/16) * 2));
                 If Y < BMP.AbsHeight -1 Then Inc(DitherArray[Offset + BMP.Width], Round((Err/16) * 3));
                 If (X < BMP.Width -1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 1 + BMP.Width], Round((Err/16) * 2));
                 If (X < BMP.Width -2) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 2 + BMP.Width], Round((Err/16) * 1));

                 Inc(Offset);

              End;
           End;

        End;

    12: // Sierra Filter Lite Error Diffusion
        Begin

           If Length(DitherArray) <> BMP.Width * BMP.AbsHeight Then
              SetLength(DitherArray, BMP.Width * BMP.AbsHeight);

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do
              For X := 0 To BMP.Width -1 Do Begin
                 DitherArray[Offset] := BMP.Pixels8[Y, X];
                 Inc(Offset);
              End;

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin

                 If DitherArray[Offset] < 0 Then DitherArray[Offset] := 0;
                 If DitherArray[Offset] > 255 Then DitherArray[Offset] := 255;

                 Clr := (DitherArray[Offset] Div 128) * 255;
                 Err := DitherArray[Offset] - Clr;
                 BMP.Pixels8[Y, X] := Clr;

                 If X < BMP.Width -1 Then Inc(DitherArray[Offset +1], Round((Err/4) * 2));
                 If (X > 0) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 1 + BMP.Width], Round((Err/4) * 1));
                 If Y < BMP.AbsHeight -1 Then Inc(DitherArray[Offset + BMP.Width], Round((Err/4) * 1));

                 Inc(Offset);

              End;
           End;

        End;

    13: // Atkinson Error Diffusion
        Begin

           If Length(DitherArray) <> BMP.Width * BMP.AbsHeight Then
              SetLength(DitherArray, BMP.Width * BMP.AbsHeight);

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do
              For X := 0 To BMP.Width -1 Do Begin
                 DitherArray[Offset] := BMP.Pixels8[Y, X];
                 Inc(Offset);
              End;

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin

                 If DitherArray[Offset] < 0 Then DitherArray[Offset] := 0;
                 If DitherArray[Offset] > 255 Then DitherArray[Offset] := 255;

                 Clr := (DitherArray[Offset] Div 128) * 255;
                 Err := DitherArray[Offset] - Clr;
                 BMP.Pixels8[Y, X] := Clr;

                 If X < BMP.Width -1 Then Inc(DitherArray[Offset +1], Round((Err/8) * 1));
                 If X < BMP.Width -2 Then Inc(DitherArray[Offset +2], Round((Err/8) * 1));
                 If (X > 0) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 1 + BMP.Width], Round((Err/8) * 1));
                 If Y < BMP.AbsHeight -1 Then Inc(DitherArray[Offset + BMP.Width], Round((Err/8) * 1));
                 If (X < BMP.Width -1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 1 + BMP.Width], Round((Err/8) * 1));
                 If Y < BMP.AbsHeight -2 Then Inc(DitherArray[Offset + (BMP.Width * 2)], Round((Err/8) * 1));

                 Inc(Offset);

              End;
           End;

        End;

    14: // Stevenson-Arce Error Diffusion
        Begin

           If Length(DitherArray) <> BMP.Width * BMP.AbsHeight Then
              SetLength(DitherArray, BMP.Width * BMP.AbsHeight);

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do
              For X := 0 To BMP.Width -1 Do Begin
                 DitherArray[Offset] := BMP.Pixels8[Y, X];
                 Inc(Offset);
              End;

           Offset := 0;
           For Y := 0 To BMP.AbsHeight -1 Do Begin
              For X := 0 To BMP.Width -1 Do Begin

                 If DitherArray[Offset] < 0 Then DitherArray[Offset] := 0;
                 If DitherArray[Offset] > 255 Then DitherArray[Offset] := 255;

                 Clr := (DitherArray[Offset] Div 128) * 255;
                 Err := DitherArray[Offset] - Clr;
                 BMP.Pixels8[Y, X] := Clr;

                 If X < BMP.Width -2 Then Inc(DitherArray[Offset +2], Round((Err/200) * 32));
                 If (X > 2) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 3 + BMP.Width], Round((Err/200) * 12));
                 If (X > 0) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset - 1 + BMP.Width], Round((Err/200) * 26));
                 If (X < BMP.Width -1) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 1 + BMP.Width], Round((Err/200) * 30));
                 If (X < BMP.Width -3) And (Y < BMP.AbsHeight -1) Then Inc(DitherArray[Offset + 3 + BMP.Width], Round((Err/200) * 16));
                 If (X > 1) And (Y < BMP.AbsHeight -2) Then Inc(DitherArray[Offset - 2 + (BMP.Width * 2)], Round((Err/200) * 12));
                 If (Y < BMP.AbsHeight -2) Then Inc(DitherArray[Offset + (BMP.Width * 2)], Round((Err/200) * 26));
                 If (Y < BMP.AbsHeight -2) And (X < BMP.Width -2) Then Inc(DitherArray[Offset + 2 + (BMP.Width * 2)], Round((Err/200) * 12));
                 If (X > 2) And (Y < BMP.AbsHeight -3) Then Inc(DitherArray[Offset - 3 + (BMP.Width * 3)], Round((Err/200) * 5));
                 If (X > 0) And (Y < BMP.AbsHeight -3) Then Inc(DitherArray[Offset - 1 + (BMP.Width * 3)], Round((Err/200) * 12));
                 If (X < BMP.Width -1) And (Y < BMP.AbsHeight -3) Then Inc(DitherArray[Offset + 1 + (BMP.Width * 3)], Round((Err/200) * 12));
                 If (X < BMP.Width -3) And (Y < BMP.AbsHeight -3) Then Inc(DitherArray[Offset + 3 + (BMP.Width * 3)], Round((Err/200) * 5));

                 Inc(Offset);

              End;
           End;

        End;

  End;

End;

end.

